const config = require('config');
const axios = require('axios');

var AUTH_TOKEN = config.get('credenciales.isApiToken');
axios.defaults.baseURL = config.get('baseUrl')
axios.defaults.headers.common = {'Authorization': `Bearer ${AUTH_TOKEN}`}

function sortProvinciasById(provincias) {
    let ids = [];
    for (let i = 0; i < provincias.length; i++) {
        ids.push(provincias[i].id_provincia);
    }

    ids.sort(function (a, b) {
        return parseInt(a) - parseInt(b)
    });

    let sortedProvincias = [];
    for (let i = 0; i < ids.length; i++) {
        sortedProvincias.push(getProvinciaById(provincias, ids[i]));
    }
    return sortedProvincias;
}

function getProvinciaById(provincias, id) {
    for (let i = 0; i < provincias.length; i++) {
        if (provincias[i].id_provincia === id) {
            return provincias[i];
        }
    }
}

module.exports =
    {
        getProvincias: async function () {
            return await axios.get('provincias/atencion')
                .then(async function (response) {
                    let provincias = response.data;
                    return sortProvinciasById(provincias);
                })
                .catch(function (error) {
                    console.log(error);
                });
        },
        getMedicosByName: async function (nombreMedico, idProvincia) {
            return await axios.get(`/medicos/atencion?id_provincia=${idProvincia}&nombre=${nombreMedico}&solo_videoconsultas`)
                .then(async function (response) {
                    return response.data.data;
                })
                .catch(function (error) {
                    console.log(error);
                });
        },
        getEspecialidadesMedico: async function (idPersonaInstitucional, idProvincia) {
            return await axios.get(`/atenciones?id_provincia=${idProvincia}&id_persona_institucional=${idPersonaInstitucional}`)
                .then(async function (response) {
                    return response.data.data;
                })
                .catch(function (error) {
                    console.log(error);
                });
        },
        getTurnosDisponibles: async function (idAgenda, idPersonaInstitucional, fecha) {
            let year = fecha.split('/')[2];
            let month = fecha.split('/')[1];
            let day = fecha.split('/')[0];
            let fechaUSA = year + "-" + month + "-" + day;
            console.log(fechaUSA);
            return await axios.get(`/turnos/turnos_disponibles?id_agenda=${idAgenda}&id_persona_institucional=${idPersonaInstitucional}&fecha=${fechaUSA}`)
                .then(async function (response) {
                    return response.data.turnos;
                })
                .catch(function (error) {
                    console.log(error);
                });
        },
        crearTurno: async function (tipoDocumento, numeroDocumento, fechaNacimiento, sexo, mail, telefono, idHorario, fechaHora) {
            return await axios.post('/watson/confirmar_reserva', {
                "tipo_documento": tipoDocumento,
                "numero_documento": numeroDocumento,
                "fecha_nacimiento": fechaNacimiento,
                "sexo": sexo,
                "mail": mail,
                "telefono_celular": telefono,
                "id_horario": idHorario,
                "fecha_hora": fechaHora
            })
                .then(async function (response) {
                    return response.data;
                })
                .catch(function (error) {
                    console.log(error);
                });
        }
    }