var Crisp = require("node-crisp-api");
var CrispClient = new Crisp();
const config = require('config');

var identifier = config.get('credenciales.crisp.identifier');
var key = config.get('credenciales.crisp.key');
let SIGUIENTE_PASO = 'siguiente_paso';

let localData = {};

CrispClient.authenticate(identifier, key);

async function sendTextMessage(website_id, session_id, message) {
    await CrispClient.websiteConversations.sendMessage(
        website_id,
        session_id, {
            type: "text",
            from: "operator",
            origin: "chat",
            content: message
        }
    );
}

async function sendPickerMessage(website_id, session_id, id, title, choices) {
    await CrispClient.websiteConversations.sendMessage(
        website_id,
        session_id, {
            type: "picker",
            from: "operator",
            origin: "chat",
            content: {
                "id": id,
                "text": title,
                "choices": choices //array
            }
        }
    );
}

async function getSiguientePaso(website_id, session_id) {
    let data = await getUserData(website_id, session_id);
    return data[SIGUIENTE_PASO];
}

async function setSiguientePaso(website_id, session_id, siguientePaso, userData) {
    if (userData == null) {
        userData = await getUserData(website_id, session_id);
    }
    userData[SIGUIENTE_PASO] = siguientePaso;
    return await updateUserData(website_id, session_id, userData);
}

async function getUserData(website_id, session_id) {
    let data = localData[website_id.concat(session_id)];
    if(data == null){
        await updateUserData(website_id, session_id, {});
        return getUserData(website_id, session_id);
    }
    return data;
}

async function updateUserData(website_id, session_id, data) {
    localData[website_id.concat(session_id)] = data;
}

module.exports =
    {
        CrispClient: CrispClient,
        sendTextMessage: sendTextMessage,
        sendPickerMessage: sendPickerMessage,
        getSiguientePaso: getSiguientePaso,
        setSiguientePaso: setSiguientePaso,
        getUserData: getUserData,
        updateUserData: updateUserData
    }