const axios = require('axios');
const config = require('config');
const handlers = require('./handlers.js');
const crisp = require('./crisp.js');
const utils = require('./utils.js');
const pasos = require('./pasos.js');
const is = require('./endpoints/is.js');
const sendinblue = require('./endpoints/sendinblue.js');

crisp.CrispClient.on("message:updated", async function (message) {
    darSiguientePaso(message, message.website_id, message.session_id);
})

async function darSiguientePaso(message, website_id, session_id) {
    let siguientePaso = await crisp.getSiguientePaso(message.website_id, message.session_id);
    let userData = await crisp.getUserData(website_id, session_id);
    handlers[siguientePaso](message, userData, website_id, session_id);
}

crisp.CrispClient.on("message:send", async function (message) {
    if(message.content === 'reiniciar'){
        await crisp.updateUserData(message.website_id, message.session_id, {});
    }
    let siguientePaso = await crisp.getSiguientePaso(message.website_id, message.session_id);
    if (siguientePaso == null) {
        enviarUserAListaSendingblue(message.website_id, message.session_id, config.get('sendingblueListId'));
        await crisp.setSiguientePaso(message.website_id, message.session_id, pasos.ASK_RESERVAR_TURNO)
    }

    await darSiguientePaso(message, message.website_id, message.session_id);
});

async function enviarUserAListaSendingblue(website_id, session_id, listId){
    let crispUsrData = await crisp.getCrispData(website_id, session_id);
    let nombreCompleto = crispUsrData['nickname']; // ej: "Lucas Mariano | Rodriguez"
    let nombres = nombreCompleto.split("|")[0].slice(0, -1);
    let apellidos = nombreCompleto.split("|")[1].substring(1);
    let email = crispUsrData['email'];
    let phone = crispUsrData['phone'];

    console.log(nombres, apellidos, email, phone);
    sendinblue.saveContactToList(email, nombres, apellidos, phone, listId);
}