const crisp = require('../crisp.js');
const utils = require('../utils.js');
const pasos = require('./pasos_ips_turnos_bajo_demanda.js');
const is = require('../endpoints/is.js')
const config = require('config');

const LINK_CONDICIONES_DE_USO = 'https://www.integrandosalud.com/es-ar/ip-condiciones-de-uso/';
const ID_AGENDA_IPS = config.get('idAgendaIPS');
const ID_DOMINIO_IPS = config.get('idDominioIPS');
let ID_PERSONA_FEDERADA;

const SI = 'SI';
const NO = 'NO';

const TIPO_DOCUMENTO = 'tipo_documento';
const NUMERO_DOCUMENTO = 'numero_documento';
const FECHA_NACIMIENTO = 'fecha_nacimiento';
const SEXO = 'sexo';
const TELEFONO = 'telefono';
const CORREO = 'correo';

function getChoiceElegida(message){
    for (let i = 0; i < message.content.choices.length; i++) {
        if (message.content.choices[i].selected === true) {
            return message.content.choices[i];
        }
    }
}

function fechaArgToFechaUsa(fechaArg){
    let year = fechaArg.split('/')[2];
    let month = fechaArg.split('/')[1];
    let day = fechaArg.split('/')[0];
    let fechaUSA = year + "-" + month + "-" + day;
    return fechaUSA;
}

async function limpiarDatos(message, userData, website_id, session_id){
    await crisp.updateUserData(website_id, session_id, {});
}

module.exports =
    {
        bienvenida: async function (message, userData, website_id, session_id) {
            await crisp.sendTextMessage(website_id, session_id, 'Hola! Soy Emilia, tu asistente virtual');
            await this.ask_acepta_condiciones(message, userData, website_id, session_id);
        },
        ask_acepta_condiciones: async function(message, userData, website_id, session_id) {
            await crisp.setSiguientePaso(website_id, session_id, pasos.RESP_ACEPTA_CONDICIONES, userData);
            await crisp.sendTextMessage(website_id, session_id, `Para continuar, debes aceptar las\n condiciones del servicio: ${LINK_CONDICIONES_DE_USO}`);
            let choices = [];
            choices.push(utils.armarChoice(SI, SI));
            choices.push(utils.armarChoice(NO, NO));
            await crisp.sendPickerMessage(website_id, session_id, pasos.RESP_ACEPTA_CONDICIONES, '¿Aceptas las condiciones de uso del servicio?', choices);
        },
        resp_acepta_condiciones: async function(message, userData, website_id, session_id) {
            const aceptaCondiciones = getChoiceElegida(message).value;
            if(aceptaCondiciones === SI){
                await crisp.sendTextMessage(website_id, session_id, 'Para que puedas atenderte con un\n profesional necesito algunos datos');
                await crisp.setSiguientePaso(website_id, session_id, pasos.ASK_TIPO_DOCUMENTO, userData);
                await this.ask_tipo_documento(message, userData, website_id, session_id);
            }
            else{
                await crisp.sendTextMessage(website_id, session_id, 'Gracias por contactarnos!');
                await limpiarDatos(message, userData, website_id, session_id);
            }
        },
        ask_tipo_documento: async function(message, userData, website_id, session_id){
            await crisp.sendTextMessage(website_id, session_id, 'Seleccioná tu tipo de documento');
            let choices = [];
            choices.push(utils.armarChoice("DNI", "DNI"));
            choices.push(utils.armarChoice("CDM", "CDM"));
            choices.push(utils.armarChoice("CED", "CED"));
            choices.push(utils.armarChoice("CIE", "CIE"));
            choices.push(utils.armarChoice("CM", "CM"));
            await crisp.sendPickerMessage(website_id, session_id, pasos.RESP_TIPO_DOCUMENTO, "Tipo de documento", choices);
            await crisp.setSiguientePaso(website_id, session_id, pasos.RESP_TIPO_DOCUMENTO, userData);
        },
        resp_tipo_documento: async function(message, userData, website_id, session_id){
            let tipoDocumentoElegido = getChoiceElegida(message);
            userData[TIPO_DOCUMENTO] = tipoDocumentoElegido.value;
            await this.ask_numero_documento(message, userData, website_id, session_id);
        },
        ask_numero_documento: async function(message, userData, website_id, session_id){
            await crisp.setSiguientePaso(website_id, session_id, pasos.RESP_NUMERO_DOCUMENTO, userData);
            await crisp.sendTextMessage(website_id, session_id, 'Ingresá tu número de documento');
        },
        resp_numero_documento: async function(message, userData, website_id, session_id){
            userData[NUMERO_DOCUMENTO] = message.content;
            await this.ask_fecha_nacimiento(message, userData, website_id, session_id);
        },
        ask_fecha_nacimiento: async function(message, userData, website_id, session_id){
            await crisp.setSiguientePaso(website_id, session_id, pasos.RESP_FECHA_NACIMIENTO, userData);
            await crisp.sendTextMessage(website_id, session_id, 'Ingresá tu fecha de nacimiento (DD/MM/AAAA)');
        },
        resp_fecha_nacimiento: async function(message, userData, website_id, session_id){
            userData[FECHA_NACIMIENTO] = message.content;
            await this.ask_sexo(message, userData, website_id, session_id);
        },
        ask_sexo: async function(message, userData, website_id, session_id){
            let choices = [];
            choices.push(utils.armarChoice("M", "Masculino"));
            choices.push(utils.armarChoice("F", "Femenino"));
            await crisp.setSiguientePaso(website_id, session_id, pasos.RESP_SEXO, userData);
            await crisp.sendPickerMessage(website_id, session_id, pasos.RESP_SEXO, 'Seleccioná tu sexo', choices);
        },
        resp_sexo: async function(message, userData, website_id, session_id){
            userData[SEXO] = getChoiceElegida(message).value;
            await this.ask_telefono(message, userData, website_id, session_id);
        },
        ask_telefono: async function(message, userData, website_id, session_id){
            await crisp.setSiguientePaso(website_id, session_id, pasos.RESP_TELEFONO, userData);
            await crisp.sendTextMessage(website_id, session_id, 'Ingresá tu teléfono');
        },
        resp_telefono: async function(message, userData, website_id, session_id){
            userData[TELEFONO] = message.content;
            await this.ask_correo(message, userData, website_id, session_id);
        },
        ask_correo: async function(message, userData, website_id, session_id){
            await crisp.setSiguientePaso(website_id, session_id, pasos.RESP_CORREO, userData);
            await crisp.sendTextMessage(website_id, session_id, 'Ingresá tu correo electrónico');
        },
        resp_correo: async function(message, userData, website_id, session_id){
            userData[CORREO] = message.content;
            let federarResp = await is.federarUsuario(userData[TIPO_DOCUMENTO], userData[NUMERO_DOCUMENTO], userData[FECHA_NACIMIENTO], userData[SEXO]);
            if(!federarResp.success){
                //Error al federar
                await crisp.sendTextMessage(website_id, session_id,'Uno de los datos ingresados es inválido');
                await crisp.sendTextMessage(website_id, session_id,'Intentemos nuevamente');
                await limpiarDatos(message, userData, website_id, session_id);
                await this.ask_tipo_documento(message, userData, website_id, session_id);
            }
            else{
                let turnoDemandaResp = await is.crearTurnoBajoDemanda(ID_AGENDA_IPS, ID_PERSONA_FEDERADA);
                if(!turnoDemandaResp.success){
                    //Error al crear turno
                    await crisp.sendTextMessage(website_id, session_id,'Disculpame, en este momento no puedo contactarte con un profesional');
                    await crisp.sendTextMessage(website_id, session_id,'Por favor, intentá de nuevo en unos minutos');
                    await limpiarDatos(message, userData, website_id, session_id);
                }
                else {
                    //Turno reservado exitosamente
                    await crisp.sendTextMessage(website_id, session_id,`Hacé click sobre "Iniciar consulta" para iniciar tu consulta`);
                    await crisp.sendTextMessage(website_id, session_id,`[Iniciar consulta](${turnoDemandaResp.link_vc})`);
                    await limpiarDatos(message, userData, website_id, session_id);
                }
            }
        }
    }