const axios = require('axios');
const config = require('config');
const handlers = require('./handlers.js');
const crisp = require('./crisp.js');
const utils = require('./utils.js');
const pasos = require('./pasos.js');
const is = require('./endpoints/is.js')

crisp.CrispClient.on("message:updated", async function (message) {
    darSiguientePaso(message, message.website_id, message.session_id);
})

async function darSiguientePaso(message, website_id, session_id) {
    let siguientePaso = await crisp.getSiguientePaso(message.website_id, message.session_id);
    let userData = await crisp.getUserData(website_id, session_id);
    handlers[siguientePaso](message, userData, website_id, session_id);
}

crisp.CrispClient.on("message:send", async function (message) {
    if(message.content === 'reiniciar'){
        await crisp.updateUserData(message.website_id, message.session_id, {});
    }
    let siguientePaso = await crisp.getSiguientePaso(message.website_id, message.session_id);
    if (siguientePaso == null) {
        await crisp.setSiguientePaso(message.website_id, message.session_id, pasos.ASK_RESERVAR_TURNO)
    }

    await darSiguientePaso(message, message.website_id, message.session_id);
});